package gov.va.med.mhv.calendar.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;


@Entity
@Table(name = "USER_CALENDAR_CAT")
public class UserCalCat implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name = "USER_CAT_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long userCatId;

	@Column(name = "OPLOCK")
	private Integer oplock=1;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "CAL_EVNT_CAT_CAL_CAT_ID")
	private CalendarCategory calendarCategory;
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "VIEW_ID")
	private UserCalView userCalView;

	public Long getUserCatId() {
		return userCatId;
	}

	public void setUserCatId(Long userCatId) {
		this.userCatId = userCatId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public CalendarCategory getCalendarCategory() {
		return calendarCategory;
	}

	public void setCalendarCategory(CalendarCategory calendarCategory) {
		this.calendarCategory = calendarCategory;
	}

	public UserCalView getUserCalView() {
		return userCalView;
	}

	public void setUserCalView(UserCalView userCalView) {
		this.userCalView = userCalView;
	}

}
